<?php
require_once 'config.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'message' => 'Only POST method allowed']);
    exit();
}

$data = json_decode(file_get_contents('php://input'), true);

$application_id = $data['application_id'] ?? 0;
$action = $data['action'] ?? ''; // 'approve' or 'reject'
$admin_notes = $data['admin_notes'] ?? '';
$admin_email = $data['admin_email'] ?? 'admin@monitor.com';

if (empty($application_id) || empty($action)) {
    echo json_encode(['success' => false, 'message' => 'Application ID and action required']);
    exit();
}

if (!in_array($action, ['approve', 'reject'])) {
    echo json_encode(['success' => false, 'message' => 'Invalid action']);
    exit();
}

$conn = getDBConnection();

$status = ($action === 'approve') ? 'approved' : 'rejected';

$stmt = $conn->prepare("UPDATE application_forms SET status=?, reviewed_at=NOW(), reviewed_by=?, admin_notes=? WHERE id=?");
$stmt->bind_param("sssi", $status, $admin_email, $admin_notes, $application_id);

if ($stmt->execute()) {
    echo json_encode([
        'success' => true,
        'message' => "Application $status successfully",
        'status' => $status
    ]);
} else {
    echo json_encode(['success' => false, 'message' => 'Failed to update application']);
}

$conn->close();
?>
