<?php
require_once 'config.php';

if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    echo json_encode(['success' => false, 'message' => 'Only GET method allowed']);
    exit();
}

$type = $_GET['type'] ?? 'all';
$device_id = $_GET['device_id'] ?? '';
$limit = intval($_GET['limit'] ?? 50);

$conn = getDBConnection();

$response = [
    'success' => true,
    'type' => $type
];

if ($type === 'devices' || $type === 'all') {
    $sql = "SELECT * FROM devices ORDER BY created_at DESC";
    $result = $conn->query($sql);
    $devices = [];
    while ($row = $result->fetch_assoc()) {
        $devices[] = $row;
    }
    $response['devices'] = $devices;
}

if ($type === 'sms' || $type === 'all') {
    $sql = "SELECT s.*, d.child_name FROM sms_messages s 
            LEFT JOIN devices d ON s.device_id = d.device_id ";
    if (!empty($device_id)) {
        $sql .= "WHERE s.device_id = ? ";
    }
    $sql .= "ORDER BY s.received_at DESC LIMIT ?";
    
    $stmt = $conn->prepare($sql);
    if (!empty($device_id)) {
        $stmt->bind_param("si", $device_id, $limit);
    } else {
        $stmt->bind_param("i", $limit);
    }
    $stmt->execute();
    $result = $stmt->get_result();
    
    $sms = [];
    while ($row = $result->fetch_assoc()) {
        $sms[] = $row;
    }
    $response['sms'] = $sms;
}

if ($type === 'calls' || $type === 'all') {
    $sql = "SELECT c.*, d.child_name FROM call_logs c 
            LEFT JOIN devices d ON c.device_id = d.device_id ";
    if (!empty($device_id)) {
        $sql .= "WHERE c.device_id = ? ";
    }
    $sql .= "ORDER BY c.call_time DESC LIMIT ?";
    
    $stmt = $conn->prepare($sql);
    if (!empty($device_id)) {
        $stmt->bind_param("si", $device_id, $limit);
    } else {
        $stmt->bind_param("i", $limit);
    }
    $stmt->execute();
    $result = $stmt->get_result();
    
    $calls = [];
    while ($row = $result->fetch_assoc()) {
        $calls[] = $row;
    }
    $response['calls'] = $calls;
}

if ($type === 'gmail' || $type === 'all') {
    $sql = "SELECT g.*, d.child_name FROM gmail_messages g 
            LEFT JOIN devices d ON g.device_id = d.device_id ";
    if (!empty($device_id)) {
        $sql .= "WHERE g.device_id = ? ";
    }
    $sql .= "ORDER BY g.received_at DESC LIMIT ?";
    
    $stmt = $conn->prepare($sql);
    if (!empty($device_id)) {
        $stmt->bind_param("si", $device_id, $limit);
    } else {
        $stmt->bind_param("i", $limit);
    }
    $stmt->execute();
    $result = $stmt->get_result();
    
    $gmail = [];
    while ($row = $result->fetch_assoc()) {
        $gmail[] = $row;
    }
    $response['gmail'] = $gmail;
}

echo json_encode($response);
$conn->close();
?>
