<?php
require_once 'config.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'message' => 'Only POST method allowed']);
    exit();
}

$data = json_decode(file_get_contents('php://input'), true);

$device_id = $data['device_id'] ?? '';
$phone_number = $data['phone_number'] ?? '';
$call_type = $data['call_type'] ?? '';
$call_status = $data['call_status'] ?? '';
$duration = $data['duration'] ?? 0;
$call_time = $data['call_time'] ?? date('Y-m-d H:i:s');

if (empty($device_id) || empty($phone_number) || empty($call_type)) {
    echo json_encode(['success' => false, 'message' => 'Required fields missing']);
    exit();
}

$conn = getDBConnection();

$check = $conn->prepare("SELECT id FROM devices WHERE device_id = ?");
$check->bind_param("s", $device_id);
$check->execute();
if ($check->get_result()->num_rows === 0) {
    echo json_encode(['success' => false, 'message' => 'Device not registered']);
    exit();
}

$stmt = $conn->prepare("INSERT INTO call_logs (device_id, phone_number, call_type, call_status, duration, call_time) VALUES (?, ?, ?, ?, ?, ?)");
$stmt->bind_param("ssssis", $device_id, $phone_number, $call_type, $call_status, $duration, $call_time);

if ($stmt->execute()) {
    echo json_encode([
        'success' => true,
        'message' => 'Call log saved',
        'call_id' => $stmt->insert_id
    ]);
} else {
    echo json_encode(['success' => false, 'message' => 'Failed to save call log']);
}

$conn->close();
?>
