<?php
require_once 'config.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'message' => 'Only POST method allowed']);
    exit();
}

$data = json_decode(file_get_contents('php://input'), true);

$device_id = $data['device_id'] ?? '';
$sender = $data['sender'] ?? '';
$sender_email = $data['sender_email'] ?? '';
$subject = $data['subject'] ?? '';
$body = $data['body'] ?? '';
$received_at = $data['received_at'] ?? date('Y-m-d H:i:s');

if (empty($device_id) || empty($sender)) {
    echo json_encode(['success' => false, 'message' => 'Required fields missing']);
    exit();
}

$conn = getDBConnection();

$check = $conn->prepare("SELECT id FROM devices WHERE device_id = ?");
$check->bind_param("s", $device_id);
$check->execute();
if ($check->get_result()->num_rows === 0) {
    echo json_encode(['success' => false, 'message' => 'Device not registered']);
    exit();
}

$stmt = $conn->prepare("INSERT INTO gmail_messages (device_id, sender, sender_email, subject, body, received_at) VALUES (?, ?, ?, ?, ?, ?)");
$stmt->bind_param("ssssss", $device_id, $sender, $sender_email, $subject, $body, $received_at);

if ($stmt->execute()) {
    echo json_encode([
        'success' => true,
        'message' => 'Gmail message saved',
        'gmail_id' => $stmt->insert_id
    ]);
} else {
    echo json_encode(['success' => false, 'message' => 'Failed to save Gmail message']);
}

$conn->close();
?>
