<?php
require_once 'config.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'message' => 'Only POST method allowed']);
    exit();
}

$data = json_decode(file_get_contents('php://input'), true);

$device_id = $data['device_id'] ?? '';
$sender = $data['sender'] ?? '';
$message = $data['message'] ?? '';
$received_at = $data['received_at'] ?? date('Y-m-d H:i:s');

if (empty($device_id) || empty($sender) || empty($message)) {
    echo json_encode(['success' => false, 'message' => 'Required fields missing']);
    exit();
}

$conn = getDBConnection();

$check = $conn->prepare("SELECT id FROM devices WHERE device_id = ?");
$check->bind_param("s", $device_id);
$check->execute();
if ($check->get_result()->num_rows === 0) {
    echo json_encode(['success' => false, 'message' => 'Device not registered']);
    exit();
}

$stmt = $conn->prepare("INSERT INTO sms_messages (device_id, sender, message, received_at) VALUES (?, ?, ?, ?)");
$stmt->bind_param("ssss", $device_id, $sender, $message, $received_at);

if ($stmt->execute()) {
    echo json_encode([
        'success' => true,
        'message' => 'SMS saved',
        'sms_id' => $stmt->insert_id
    ]);
} else {
    echo json_encode(['success' => false, 'message' => 'Failed to save SMS']);
}

$conn->close();
?>
