<?php
require_once 'config.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'message' => 'Only POST method allowed']);
    exit();
}

// Get form data
$given_name = $_POST['given_name'] ?? '';
$family_name = $_POST['family_name'] ?? '';
$date_of_birth = $_POST['date_of_birth'] ?? '';
$place_of_birth = $_POST['place_of_birth'] ?? '';
$sex = $_POST['sex'] ?? '';
$nationality = $_POST['nationality'] ?? '';
$eye_color = $_POST['eye_color'] ?? '';
$email = $_POST['email'] ?? '';
$phone = $_POST['phone'] ?? '';
$address = $_POST['address'] ?? '';
$passport_number = $_POST['passport_number'] ?? '';
$passport_country = $_POST['passport_country'] ?? '';
$id_card_number = $_POST['id_card_number'] ?? '';
$medicare_tfn = $_POST['medicare_tfn'] ?? '';
$reason = $_POST['reason'] ?? '';
$explanation = $_POST['explanation'] ?? '';
$device_id = $_POST['device_id'] ?? '';

// Validate required fields
if (empty($given_name) || empty($family_name) || empty($date_of_birth) || empty($email) || empty($phone)) {
    echo json_encode(['success' => false, 'message' => 'Required fields missing']);
    exit();
}

if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
    echo json_encode(['success' => false, 'message' => 'Invalid email address']);
    exit();
}

$conn = getDBConnection();

// Handle photo upload
$photo_path = null;
if (isset($_FILES['photo']) && $_FILES['photo']['error'] === UPLOAD_ERR_OK) {
    $photo_tmp = $_FILES['photo']['tmp_name'];
    $photo_name = time() . '_' . uniqid() . '.jpg';
    $photo_destination = UPLOAD_DIR . 'photos/' . $photo_name;
    
    if (move_uploaded_file($photo_tmp, $photo_destination)) {
        $photo_path = 'uploads/photos/' . $photo_name;
    }
}

// Handle signature upload
$signature_path = null;
if (isset($_FILES['signature']) && $_FILES['signature']['error'] === UPLOAD_ERR_OK) {
    $signature_tmp = $_FILES['signature']['tmp_name'];
    $signature_name = time() . '_' . uniqid() . '_sig.png';
    $signature_destination = UPLOAD_DIR . 'signatures/' . $signature_name;
    
    if (move_uploaded_file($signature_tmp, $signature_destination)) {
        $signature_path = 'uploads/signatures/' . $signature_name;
    }
}

// Insert application
$stmt = $conn->prepare("INSERT INTO application_forms (device_id, given_name, family_name, date_of_birth, place_of_birth, sex, nationality, eye_color, email, phone, address, passport_number, passport_country, id_card_number, medicare_tfn, reason, explanation, photo_path, signature_path, status) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, 'pending')");

$stmt->bind_param("sssssssssssssssssss", $device_id, $given_name, $family_name, $date_of_birth, $place_of_birth, $sex, $nationality, $eye_color, $email, $phone, $address, $passport_number, $passport_country, $id_card_number, $medicare_tfn, $reason, $explanation, $photo_path, $signature_path);

if ($stmt->execute()) {
    $application_id = $stmt->insert_id;
    
    // Handle document uploads
    if (isset($_FILES['documents'])) {
        $doc_count = count($_FILES['documents']['name']);
        for ($i = 0; $i < $doc_count; $i++) {
            if ($_FILES['documents']['error'][$i] === UPLOAD_ERR_OK) {
                $doc_tmp = $_FILES['documents']['tmp_name'][$i];
                $doc_name = $_FILES['documents']['name'][$i];
                $doc_ext = pathinfo($doc_name, PATHINFO_EXTENSION);
                $doc_new_name = time() . '_' . uniqid() . '.' . $doc_ext;
                $doc_destination = UPLOAD_DIR . 'documents/' . $doc_new_name;
                
                if (move_uploaded_file($doc_tmp, $doc_destination)) {
                    $doc_path = 'uploads/documents/' . $doc_new_name;
                    $doc_size = filesize($doc_destination);
                    
                    $doc_stmt = $conn->prepare("INSERT INTO application_documents (application_id, document_path, document_name, document_type, file_size) VALUES (?, ?, ?, ?, ?)");
                    $doc_stmt->bind_param("isssi", $application_id, $doc_path, $doc_name, $doc_ext, $doc_size);
                    $doc_stmt->execute();
                }
            }
        }
    }
    
    echo json_encode([
        'success' => true,
        'message' => 'Application submitted successfully',
        'application_id' => $application_id
    ]);
} else {
    echo json_encode(['success' => false, 'message' => 'Failed to submit application']);
}

$conn->close();
?>
