<?php
require_once 'config.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'message' => 'Invalid request method']);
    exit;
}

$device_id = isset($_POST['device_id']) ? trim($_POST['device_id']) : '';
$sender = isset($_POST['sender']) ? trim($_POST['sender']) : '';
$message = isset($_POST['message']) ? trim($_POST['message']) : '';
$received_at = isset($_POST['received_at']) ? trim($_POST['received_at']) : date('Y-m-d H:i:s');

// Validation
if (empty($device_id) || empty($sender) || empty($message)) {
    echo json_encode(['success' => false, 'message' => 'Missing required fields']);
    exit;
}

$conn = getDBConnection();

// Verify device exists
$stmt = $conn->prepare("SELECT id FROM devices WHERE device_id = ?");
$stmt->bind_param("s", $device_id);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 0) {
    echo json_encode(['success' => false, 'message' => 'Device not registered']);
    exit;
}

// Insert SMS record
$stmt = $conn->prepare("INSERT INTO sms_messages (device_id, sender, message, received_at, created_at) VALUES (?, ?, ?, ?, NOW())");
$stmt->bind_param("ssss", $device_id, $sender, $message, $received_at);

if ($stmt->execute()) {
    echo json_encode([
        'success' => true,
        'message' => 'SMS saved successfully',
        'sms_id' => $stmt->insert_id
    ]);
} else {
    echo json_encode([
        'success' => false,
        'message' => 'Failed to save SMS: ' . $stmt->error
    ]);
}

$stmt->close();
$conn->close();
?>
