-- Parental Control Monitoring System Database
-- Created for InfinityFree Hosting

-- Database creation (শুধু রেফারেন্সের জন্য, phpMyAdmin এ ম্যানুয়ালি ডাটাবেস তৈরি করতে হবে)
-- CREATE DATABASE IF NOT EXISTS parental_control_db CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
-- USE parental_control_db;

-- Table 1: Devices (ডিভাইস রেজিস্ট্রেশন)
CREATE TABLE IF NOT EXISTS `devices` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `device_id` VARCHAR(100) NOT NULL UNIQUE,
  `child_name` VARCHAR(100) NOT NULL,
  `parent_name` VARCHAR(100) NOT NULL,
  `parent_email` VARCHAR(100) NOT NULL,
  `created_at` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` DATETIME NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `idx_device_id` (`device_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table 2: SMS Messages (এসএমএস মেসেজ)
CREATE TABLE IF NOT EXISTS `sms_messages` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `device_id` VARCHAR(100) NOT NULL,
  `sender` VARCHAR(50) NOT NULL,
  `message` TEXT NOT NULL,
  `received_at` DATETIME NOT NULL,
  `created_at` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `idx_device_id` (`device_id`),
  INDEX `idx_received_at` (`received_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table 3: Call Logs (কল লগ)
CREATE TABLE IF NOT EXISTS `call_logs` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `device_id` VARCHAR(100) NOT NULL,
  `phone_number` VARCHAR(50) NOT NULL,
  `call_type` ENUM('incoming', 'outgoing') NOT NULL DEFAULT 'incoming',
  `call_status` VARCHAR(20) NOT NULL,
  `duration` INT(11) NOT NULL DEFAULT 0,
  `call_time` DATETIME NOT NULL,
  `created_at` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `idx_device_id` (`device_id`),
  INDEX `idx_call_time` (`call_time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table 4: Applications (অ্যাপ্লিকেশন তালিকা) - ভবিষ্যতের জন্য
CREATE TABLE IF NOT EXISTS `applications` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `device_id` VARCHAR(100) NOT NULL,
  `app_name` VARCHAR(200) NOT NULL,
  `package_name` VARCHAR(200) NOT NULL,
  `installed_at` DATETIME NULL DEFAULT NULL,
  `created_at` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `idx_device_id` (`device_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table 5: Gmail OTP Logs (Gmail OTP) - ভবিষ্যতের জন্য
CREATE TABLE IF NOT EXISTS `gmail_otp_logs` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `device_id` VARCHAR(100) NOT NULL,
  `sender` VARCHAR(100) NOT NULL,
  `subject` VARCHAR(255) NOT NULL,
  `otp_code` VARCHAR(20) NOT NULL,
  `received_at` DATETIME NOT NULL,
  `created_at` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `idx_device_id` (`device_id`),
  INDEX `idx_received_at` (`received_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Insert Sample Data (টেস্টিং এর জন্য)
-- একটি স্যাম্পল ডিভাইস
INSERT INTO `devices` (`device_id`, `child_name`, `parent_name`, `parent_email`, `created_at`) VALUES
('TEST_DEVICE_123', 'টেস্ট শিশু', 'টেস্ট অভিভাবক', 'test@example.com', NOW());

-- একটি স্যাম্পল এসএমএস
INSERT INTO `sms_messages` (`device_id`, `sender`, `message`, `received_at`, `created_at`) VALUES
('TEST_DEVICE_123', '+8801700000000', 'এটি একটি টেস্ট মেসেজ', NOW(), NOW());

-- একটি স্যাম্পল কল লগ
INSERT INTO `call_logs` (`device_id`, `phone_number`, `call_type`, `call_status`, `duration`, `call_time`, `created_at`) VALUES
('TEST_DEVICE_123', '+8801700000000', 'incoming', 'answered', 120, NOW(), NOW());

-- Database Schema Complete
-- সম্পূর্ণ ডাটাবেস স্কিমা তৈরি হয়ে গেছে
